/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxAdapter
implements PopupMenuListener,
ItemListener {
    private ItemEvent itemEvent;
    private ItemListener delegate;
    private boolean itemChanged;
    private boolean popupMenuVisible;

    protected ComboBoxAdapter(ItemListener delegate) {
        this.delegate = delegate;
    }

    public ItemListener getDelegate() {
        return this.delegate;
    }

    @Override
    public final void itemStateChanged(ItemEvent e) {
        if (this.popupMenuVisible) {
            if (e.getStateChange() == 1) {
                this.itemChanged = true;
                this.itemEvent = e;
            }
        } else {
            this.delegate.itemStateChanged(e);
        }
    }

    @Override
    public final void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public final void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.itemChanged) {
            this.delegate.itemStateChanged(this.itemEvent);
        }
    }

    @Override
    public final void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.popupMenuVisible = true;
    }

    public static void addItemListener(JComboBox comboBox, ItemListener listener) {
        ComboBoxAdapter adapter = new ComboBoxAdapter(listener);
        comboBox.addItemListener(adapter);
        comboBox.addPopupMenuListener(adapter);
    }

    public static void removeItemListener(JComboBox comboBox, ItemListener listener) {
        ItemListener[] itemListeners;
        for (ItemListener i : itemListeners = comboBox.getItemListeners()) {
            ComboBoxAdapter adapter;
            if (!(i instanceof ComboBoxAdapter) || (adapter = (ComboBoxAdapter)i).getDelegate() != listener) continue;
            comboBox.removeItemListener(adapter);
            comboBox.removePopupMenuListener(adapter);
        }
    }
}

